% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.jags.R
\name{write.beta}
\alias{write.beta}
\title{Adds sections of JAGS code for an MBNMA model that correspond to beta
parameters}
\usage{
write.beta(model, timecourse, fun, UME, class.effect)
}
\arguments{
\item{model}{A character object of JAGS MBNMA model code}

\item{timecourse}{A character object representing the time-course used in the MBNMA model}

\item{fun}{An object of class \code{"timefun"} generated (see Details) using any of
\code{tloglin()}, \code{tpoly()}, \code{titp()}, \code{temax()}, \code{tfpoly()}, \code{tspline()} or \code{tuser()}}

\item{UME}{Can take either \code{TRUE} or \code{FALSE} (for an unrelated mean effects
model on all or no time-course parameters respectively) or can be a vector
of parameter name strings to model as UME. For example: \code{c("beta.1", "beta.2")}.}

\item{class.effect}{A list of named strings that determines which time-course
parameters to model with a class effect and what that effect should be
(\code{"common"} or \code{"random"}). For example: \code{list(emax="common", et50="random")}.}
}
\value{
A character vector of JAGS MBNMA model code that includes beta
parameter components of the model
}
\description{
Adds sections of JAGS code for an MBNMA model that correspond to beta
parameters
}
