% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.functions.R
\name{titp}
\alias{titp}
\title{Integrated Two-Component Prediction (ITP) function}
\usage{
titp(
  pool.emax = "rel",
  method.emax = "common",
  pool.rate = "rel",
  method.rate = "common",
  p.expon = FALSE
)
}
\arguments{
\item{pool.emax}{Pooling for exponential Emax parameter. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.emax}{Method for synthesis of exponential Emax parameter. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}

\item{pool.rate}{Pooling for parameter controlling rate of onset. Default is \code{NULL} which avoids including
this parameter (i.e. fixes it to 1 for all treatments). Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.rate}{Method for synthesis of parameter controlling rate of onset. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}

\item{p.expon}{Should parameters that can only take positive values be modeled on the exponential scale (\code{TRUE})
or should they be assigned a prior that restricts the posterior to positive values (\code{FALSE})}
}
\value{
An object of \code{class("timefun")}
}
\description{
Similar parameterisation to the Emax model but with non-asymptotic maximal effect (Emax). Proposed
by proposed by \insertCite{fumanner;textual}{MBNMAtime}
}
\details{
\deqn{{E_{max}}\times\frac{(1-exp(-{rate}\times{x}))}{(1-exp(-{rate}\times{max(x)}))}}
}
\section{Time-course parameters}{

Time-course parameters in the model must be specified using a \code{pool} and a \code{method} prefix.

\code{pool} is used to define the approach used for pooling of a given time-course parameter and
can take any of:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Indicates that \emph{relative} effects should be pooled for this time-course parameter. Relative effects preserve randomisation within included studies, are likely to vary less between studies (only due to effect modification), and allow for testing of consistency between direct and indirect evidence. Pooling follows the general approach for Network Meta-Analysis proposed by \insertCite{lu2004;textual}{MBNMAtime}. \cr
   \code{"abs"} \tab Indicates that study arms should be pooled across the whole network for this time-course parameter  \emph{independently of assigned treatment} to estimate an \emph{absolute} effect. This implies estimating a single value across the network for this time-course parameter, and may therefore be making strong assumptions of similarity. \cr
}


\code{method} is used to define the model used for meta-analysis for a given time-course parameter
and can take any of the following values:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"common"} \tab Implies that all studies estimate the same true effect (often called a "fixed effect" meta-analysis) \cr
   \code{"random"} \tab Implies that all studies estimate a separate true effect, but that each of these true effects vary randomly around a true mean effect. This approach allows for modelling of between-study heterogeneity. \cr
   \code{numeric()} \tab Assigned a numeric value, indicating that this time-course parameter should not be estimated from the data but should be assigned the numeric value determined by the user. This can be useful for fixing specific time-course parameters (e.g. Hill parameters in Emax functions, power parameters in fractional polynomials) to a single value. \cr
}
}

\examples{
titp(pool.emax="rel", method.emax="random")
titp(pool.emax="abs")

}
\references{
\insertAllCited
}
