% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBPLS.R
\name{MBPLS}
\alias{MBPLS}
\title{Multiblock Partial Least Squares Regression}
\usage{
MBPLS(
  X,
  Y,
  block,
  name.block = NULL,
  ncomp = NULL,
  scale = TRUE,
  scale.block = TRUE,
  scale.Y = TRUE
)
}
\arguments{
\item{X}{Dataset obtained by horizontally merging all the predictor blocks of variables.}

\item{Y}{Response block of variables.}

\item{block}{Vector indicating the number of variables in each predictor block.}

\item{name.block}{Names of the predictor blocks of variables (NULL by default).}

\item{ncomp}{Number of dimensions to compute. By default (NULL), all the global components are extracted.}

\item{scale}{Logical, if TRUE (by default) the variables in X are scaled to unit variance (all variables in X are centered anyway).}

\item{scale.block}{Logical, if TRUE (by default) each predictor block of variables is divided by the square root of its inertia (Frobenius norm).}

\item{scale.Y}{Logical, if TRUE (by default) then variables in Y are scaled to unit variance (all variables in Y are centered anyway).}
}
\value{
Returns a list of the following elements:\cr

\item{optimalcrit}{Numeric vector of the optimal value of the criterion (sum of saliences) obtained for each dimension.}

\item{saliences}{Matrix of the specific weights of each predictor block on the global components, for each dimension.}

\item{T.g}{Matrix of normed global components.}

\item{Scor.g}{Matrix of global components (scores of individuals).}

\item{W.g}{Matrix of global weights (normed) associated with deflated X.}

\item{Load.g}{Matrix of global loadings.}

\item{Proj.g}{Matrix of global projection (to compute scores from pretreated X).}

\item{explained.X}{Matrix of percentages of inertia explained in each predictor block.}

\item{cumexplained}{Matrix giving the percentages, and cumulative percentages, of total inertia of X and Y blocks explained by the global components.}

\item{Y}{A list containing un-normed Y components (U), normed Y weights (W.Y) and Y loadings (Load.Y)}

\item{Block}{A list containing block components (T.b) and block weights (W.b)}
}
\description{
MB-PLS regression applied to a set of quantitative blocks of variables.
}
\examples{
data(ham)
X=ham$X
block=ham$block
Y=ham$Y
res.mbpls <- MBPLS(X, Y, block, name.block = names(block))
summary(res.mbpls)
plot(res.mbpls)

}
\references{
S. Wold (1984). Three PLS algorithms according to SW. In: Symposium MULDAST (Multivariate Analysis in
Science and Technology), Umea University, Sweden. pp. 26–30.\cr

E. Tchandao Mangamana, R. Glèlè Kakaï, E.M. Qannari (2021). A general strategy for setting up supervised methods of multiblock data analysis.
Chemometrics and Intelligent Laboratory Systems, 217, 104388.
}
\seealso{
\code{\link{summary.MBPLS}}    \code{\link{plot.MBPLS}}
}
