% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-multinomial_aggregation.R
\name{amultinomial}
\alias{amultinomial}
\title{Aggregate multinomial data. Used in \code{\link{aggregate_df}}.}
\usage{
amultinomial(data, col_name, all_categories = NULL)
}
\arguments{
\item{data}{A vector containing the multinomial observations (will be coerced to character).}

\item{col_name}{A character string giving the name of the column (primarily for context/error messages, less critical now).}

\item{all_categories}{A character vector with the names or levels of all possible categories in the multinomial distribution (must include all observed values after coercion to character).}
}
\value{
A one-row data frame containing counts for each of the first \eqn{K - 1} categories.
}
\description{
Aggregates multinomial data into sufficient statistics for multinomial samples. \cr
Converts input data to character before processing.
For a sample \eqn{\boldsymbol{y} = \{y_1, \dots, y_n\}} with \eqn{y_i \in \{1, \dots, K\}}, \eqn{P(y_i = k) = p_k, k=1, \dots, K}, the sample is aggregated into the sufficient statistic \cr \cr
\eqn{\boldsymbol{s} = (s_1, \dots, s_{K-1})} \cr \cr
where \cr \cr
\eqn{s_k = \sum_{i=1}^n \mathbb{I}(y_i = k)} for \eqn{k = 1, \dots, K-1}. \cr \cr
(The last category is omitted due to the sum-to-one constraint)
}
\keyword{internal}
