% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RotationCostBestGivenGraph.R
\name{RotationCostBestGivenGraph}
\alias{RotationCostBestGivenGraph}
\title{Evaluate the cluster number of multiple modality data}
\usage{
RotationCostBestGivenGraph(W, NUMC = 2:5)
}
\arguments{
\item{W}{a list of multiple modality data matrices}

\item{NUMC}{a vector specify the data range to select best cluster number}
}
\value{
quality, a vector of rotation cost the same long as NUMC, where each element is the rotation cost value of the corresponding cluster number.
}
\description{
Evaluate the cluster number of multiple modality data
}
\examples{
library(InterSIM)
library(SNFtool)
sim.data <- InterSIM(n.sample=100, cluster.sample.prop = c(0.20,0.30,0.27,0.23),
delta.methyl=5, delta.expr=5, delta.protein=5,p.DMP=0.2, p.DEG=NULL,
p.DEP=NULL,sigma.methyl=NULL, sigma.expr=NULL, sigma.protein=NULL,cor.methyl.expr=NULL,
cor.expr.protein=NULL,do.plot=FALSE, sample.cluster=TRUE, feature.cluster=TRUE)
sim.methyl <- sim.data$dat.methyl
sim.expr <- sim.data$dat.expr
sim.protein <- sim.data$dat.protein
temp_data <- list(sim.methyl, sim.expr, sim.protein)
dat <- lapply(temp_data, function(dd) {
  dd <- as.matrix(dd)
  dd1 <- dist2(dd,dd)
  W1 <- affinityMatrix(dd1, K = 10, sigma = 0.5)
})
W <- SNF(dat, 10, 10)
clu_eval <- RotationCostBestGivenGraph(W,2:10)
}
