% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_L.R
\name{update_L}
\alias{update_L}
\title{the function to update Li, for i=1,2,...,N}
\usage{
update_L(WL, init_list)
}
\arguments{
\item{WL}{A list of similarity matrices}

\item{init_list}{A list with N+2 elements, the former N as modality private sub-matrices, the Nth as the shared sub-matrix and the last one as 1}
}
\value{
A list containing the updated result in this iteration
}
\description{
update the sub-matrix Li, for i=1,2,...,N to convergence to its local minimum gradually
}
\examples{
WL <- simu_data_gen()
WL[[1]] <- affinityMatrix(dist2eu(Standard_Normalization(WL[[1]]),Standard_Normalization(WL[[1]])))
WL[[2]] <- affinityMatrix(dist2eu(Standard_Normalization(WL[[2]]),Standard_Normalization(WL[[2]])))
new_WL_list <- initialize_WL(WL)
k <- 5
init_list <- initialization(new_WL_list,k)
update_L_list <- update_L(WL,init_list)
}
\author{
Xiaoyao Yin
}
