% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_config.R
\name{object_config}
\alias{object_config}
\title{Set taxonomy summary configuration}
\usage{
object_config(
  taxobj,
  treat_location,
  facet_location = NULL,
  rep_location,
  subject_location = NULL,
  treat_col = NULL,
  treat_order = NULL,
  facet_order = NULL
)
}
\arguments{
\item{taxobj}{Taxonomic summary object generated by \code{\link{tax_summary}}}

\item{treat_location}{Numeric. Treatment column number in metafile/groupinformation.}

\item{facet_location}{Numeric, default:NULL. Facet column number in metafile/groupinformation.}

\item{rep_location}{Numeric. Replication column number in metafile/groupinformation.}

\item{subject_location}{Numeric, default:NULL.Subject column number in metafile/groupinformation (used for pairwise experiment).}

\item{treat_col}{Named character string, default:NULL. A set of aesthetic character to map treatment to.}

\item{treat_order}{Character string, default:NULL. The character string indicating treatment displaying order.}

\item{facet_order}{Character string, default:NULL. The character string indicating facet displaying order.}
}
\value{
object_config returns taxonomy summary object with configuration.
}
\description{
This function set taxonomy summary configuration by assigning treatment column number, facet column number, replication column number, treatment mapping color, treatment order and facet order.
}
\examples{
{
  ### Data preparation ###
  data(testotu)
  groupinformation <- data.frame(
    group = c(rep("a", 10), rep("b", 10)),
    factor1 = rnorm(10),
    factor2 = rnorm(mean = 100, 10),
    subject = factor(c(1:10, 1:10)),
    group2 = c(rep("e", 5), rep("f", 5), rep("e", 5), rep("f", 5))
  )

  ### Packaging metafile, community data, and taxonomy table ###
  test_object <- tax_summary(
    groupfile = groupinformation,
    inputtable = testotu[, 2:21],
    reads = TRUE,
    taxonomytable = testotu[, c(1, 22)]
  )

  ### Object configuration ###
  test_object_plan1 <- object_config(
    taxobj = test_object,
    treat_location = 1,
    rep_location = 4
  )

  ### Facet configuration ###
  test_object_plan2 <- object_config(
    taxobj = test_object,
    treat_location = 1,
    rep_location = 4,
    facet_location = 5
  )
}
}
\author{
Wang Ningqi\href{mailto:2434066068@qq.com}{2434066068@qq.com}
}
