% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_visual_re.R
\name{network_visual_re}
\alias{network_visual_re}
\title{Re-visualize network plot from \code{\link{network_visual}} or \code{\link{network_withdiff}}}
\usage{
network_visual_re(
  network_visual_obj,
  module_paint = FALSE,
  module_num = NULL,
  module_palette = c("aquamarine3", "antiquewhite2", "goldenrod2"),
  vertex.size = 6,
  vertex.shape = "circle"
)
}
\arguments{
\item{network_visual_obj}{Network object from \code{\link{network_visual}} or \code{\link{network_withdiff}}}

\item{module_paint}{Logical. If network module should be painted. Only work for network object from \code{\link{network_withdiff}}.}

\item{module_num}{Numeric indicating which module to be painted.}

\item{module_palette}{Character string with at least two elements. Palette for painting modules.}

\item{vertex.size}{Numeric. The size of the vertices, default:6. Only for network object from \code{\link{network_visual}}}

\item{vertex.shape}{Character. The shape of vertices, default: "circle"}
}
\value{
NULL but visualization in plot panel.
}
\description{
Re-visualize network plot from \code{\link{network_visual}} or \code{\link{network_withdiff}}
}
