% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_taxonomic_level.R
\name{get_taxonomic_level}
\alias{get_taxonomic_level}
\title{Get Specified Taxonomic Level from Taxonomic Strings}
\usage{
get_taxonomic_level(taxonomies, level, full_names = TRUE, delimiter = ";")
}
\arguments{
\item{taxonomies}{A character vector of taxonomic strings.}

\item{level}{A numeric value representing the taxonomic level to be extracted. A value of \code{1} retrieves the highest taxonomic level (\emph{e.g.}, domain) from the input taxonomies, with each sequentially higher value retrieving sequentially lower taxonomic levels. \code{0} is a special value which retrieves the lowest taxonomic level available in the input taxonomies.}

\item{full_names}{Logical. If \code{TRUE} (the default), then full taxonomies are returned down to the requested taxonomic level. If \code{FALSE}, then only the requested taxonomic level is returned.}

\item{delimiter}{A character string of the delimiter between taxonomic levels in the input taxonomies. The default is \code{";"}.}
}
\value{
A character vector containing the requested taxonomic level for each element of the input taxonomies.
}
\description{
Gets the specified taxonomic level from a vector of taxonomic strings.
}
\examples{
get_taxonomic_level(taxonomies=
   c("Eukaryota;Chordata;Amphibia;Caudata;Ambystomatidae;Ambystoma;Ambystoma_mavortium",
     "Eukaryota;Chordata;Amphibia;Anura;Bufonidae;Anaxyrus;Anaxyrus_boreas",
     "Eukaryota;Chordata;Amphibia;Anura;Ranidae;Rana;Rana_luteiventris"),
   level=5,
   full_names=TRUE,
   delimiter=";")
}
