% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{sepclass}
\alias{sepclass}
\title{sepclass()}
\usage{
sepclass(data, pattern, subtype = FALSE)
}
\arguments{
\item{data}{A dataframe storing concentration of lipids between different samples.
The column name should be the sample name and the row name should be the lipid type.
The class of column name and row name should be "character". The class of values should be
"numeric". The row names are recommended to be in a form like "PL(14:0/20:1)" or "LPL(16:1)".}

\item{pattern}{Can accept 4 values: "lipid", "CB", "sat", or "all"

    If pattern="lipid“, a new column named "lipid_type" will be added, which stores type of lipid like "PE", "LPC", and "TAG".

    If pattern="CB“, a new column named "carbon_number" will be added, which stores the number of carbons. For example, the carbon_number of "PC(14:0/16:1)" is 14+16=30.

    If pattern="sat“, a new column named "unsaturation" will be added, which stores the number of double bonds. For example, the unsaturation of "PC(14:1/16:1)" is 1+1=2.

    If pattern="all“, all three columns will be added.}

\item{subtype}{A logic value to determine for a lipid like "PC(O-14:0/16:1)", "lipid_type" should be
"PC" (subtype=FALSE) or "PC(O)" (subtype=TRUE). Default value is FALSE.}
}
\value{
A dataframe with new columns containing the class of lipid type, carbon number,
or unsaturation based on the original data input.
}
\description{
A function to identify lipid type and calculate the number of carbons and
unsaturation rate of lipids.
}
\examples{
WT_1=rnorm(n=5,mean=0.3,sd=0.1)
WT_2=rnorm(n=5,mean=0.3,sd=0.1)
WT_3=rnorm(n=5,mean=0.3,sd=0.1)
KO_1=rnorm(n=5,mean=0.3,sd=0.1)
KO_2=rnorm(n=5,mean=0.3,sd=0.1)
KO_3=rnorm(n=5,mean=0.3,sd=0.1)
data=data.frame(WT_1,WT_2,WT_3,KO_1,KO_2,KO_3)
rownames(data)=c("LPC(16:0)","PC(O-14:0/16:1)","TAG56:2-FA20:1","PE(P-18:0/20:1)","PS(20:1/20:1)")
pattern="all" ## or "lipid", "CB", "sat"
sepclass(data,pattern)
}
