% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LikertEZ.R
\name{rank_items}
\alias{rank_items}
\title{Rank items by RII or Mean}
\usage{
rank_items(data, method = "rii", max_scale = 5, n = 5, top = TRUE)
}
\arguments{
\item{data}{A data.frame of ordinal items.}

\item{method}{Method to rank items. Either "rii" (for Relative Importance Index) or "mean" (for mean response).}

\item{max_scale}{Max Likert scale value (default: 5).}

\item{n}{Number of top items to return (default: 5).}

\item{top}{Logical. If TRUE, returns the top items, otherwise returns the bottom items (default: TRUE).}
}
\value{
A vector of ranked items.
}
\description{
This function ranks items in the data based on either the Relative Importance Index (RII) or the mean of responses.
}
