% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_gaps.R
\name{gg_gaps}
\alias{gg_gaps}
\title{Visualize gaps and irregular data}
\usage{
gg_gaps(
  dataset,
  Variable.colname = MEDI,
  Datetime.colname = Datetime,
  fill.gaps = "red",
  col.irregular = "red",
  alpha = 0.5,
  on.top = FALSE,
  epoch = "dominant.epoch",
  full.days = TRUE,
  show.irregulars = FALSE,
  group.by.days = FALSE,
  include.implicit.gaps = TRUE,
  ...
)
}
\arguments{
\item{dataset}{A light logger dataset. Expects a \code{dataframe}. If not imported
by \link{LightLogR}, take care to choose a sensible variable for the \code{x.axis.}.}

\item{Variable.colname}{Variable that becomes the basis for gap analysis.
expects a symbol}

\item{Datetime.colname}{The column that contains the datetime. Needs to be a
\code{POSIXct} and part of the dataset.}

\item{fill.gaps}{Fill color for the gaps}

\item{col.irregular}{Dot color for irregular data}

\item{alpha}{A numerical value between 0 and 1 representing the transparency
of the gaps Default is 0.5.}

\item{on.top}{Logical scalar. If \code{TRUE}, the states will be plotted on top of
the existing plot. If \code{FALSE}, the states will be plotted underneath the}

\item{epoch}{The epoch to use for the gapless sequence. Can be either a
\code{lubridate::duration()} or a string. If it is a string, it needs to be
either '"dominant.epoch"' (the default) for a guess based on the data or a
valid \code{lubridate::duration()} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{full.days}{Logical. Whether full days are expected, even for the first
and last measurement}

\item{show.irregulars}{Logical. Show irregular data points. Default is
\code{FALSE}.}

\item{group.by.days}{Logical. Whether data should be grouped by days. This
can make sense if only very few days from large groups are affected}

\item{include.implicit.gaps}{Logical. Whether the time series should be expanded only the current observations taken.}

\item{...}{Additional arguments given to \code{\link[=gg_days]{gg_days()}}. Can be used to change
the color or other aesthetic properties.}
}
\value{
a \code{ggplot} object with all gaps and optionally irregular data.
Groups that do not have any gaps nor irregular data will be removed for
clarity. Null if no groups remain
}
\description{
\code{\link[=gg_gaps]{gg_gaps()}} is built upon \code{\link[=gg_days]{gg_days()}}, \code{\link[=gap_finder]{gap_finder()}}, and \code{\link[=gg_state]{gg_state()}} to
visualize where gaps and irregular data in a dataset are. The function does
not differentiate between \verb{implicit gaps}, which are missing timestamps of
the regular interval, \verb{explicit gaps}, which are \code{NA} values. Optionally, the
function shows \verb{irregular data}, which are datapoints that fall outside the
regular interval.
}
\examples{
#calling gg_gaps on a healthy dataset is pointless
sample.data.environment |> gg_gaps()

#creating a gapped and irregular dataset
bad_dataset <-
sample.data.environment |>
  aggregate_Datetime(unit = "5 mins") |>
  dplyr::filter(Id == "Participant") |> 
  filter_Date(length = "2 days") |>
  dplyr::mutate(
   Datetime = dplyr::if_else(
     lubridate::date(Datetime) == max(lubridate::date(Datetime)),
           Datetime, Datetime + 1
     )
   ) |>
dplyr::filter(MEDI <250)
bad_dataset |> has_gaps()
bad_dataset |> has_irregulars()

#by default, gg_gaps() only shows gaps
bad_dataset |> gg_gaps()

#it can also show irregular data
bad_dataset |> gg_gaps(show.irregulars = TRUE)
}
