% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_dose.R
\name{dose}
\alias{dose}
\title{Calculate the dose (value·hours)}
\usage{
dose(
  Light.vector,
  Time.vector,
  epoch = "dominant.epoch",
  na.rm = FALSE,
  as.df = FALSE
)
}
\arguments{
\item{Light.vector}{Numeric vector containing the light data.}

\item{Time.vector}{Vector containing the time data. Can be
\link[base]{POSIXct}, \link[hms]{hms}, \link[lubridate]{duration}, or
\link[base]{difftime}.}

\item{epoch}{The epoch at which the data was sampled. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be
either \code{"dominant.epoch"} (the default) for a guess based on the data, or a
valid \link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{na.rm}{Logical. Should missing values (NA) be removed for the
calculation? Defaults to \code{FALSE}.}

\item{as.df}{Logical. Should a data frame with be returned? If \code{TRUE}, a data
frame with a single column named \code{dose} will be returned. Defaults to
\code{FALSE}.}
}
\value{
A numeric object as single value, or single column data frame with the dose in value·hours
}
\description{
This function calculates the dose from a time series. For light, this is
equal to the actual definition of light exposure (CIE term luminous
exposure). Output will always be provided in value·hours (e.g., for light, lx·hours).
}
\details{
The time series does not have to be regular, however, it will be aggregated
to a regular timeseries of the given epoch. Implicit gaps (i.e., no
observations), will be converted to NA values (which can be ignored with
\code{na.rm = TRUE}).
}
\examples{

dose(c(1,1,1,1), lubridate::dhours(c(1:4)), na.rm = TRUE)
#with gaps
dose(c(1,1,1), lubridate::dhours(c(1,3:4)), na.rm = TRUE)
#gaps can be aggregated to a coarser interval, which can be sensibe
#if they are still representative
dose(c(1,1,1), lubridate::dhours(c(1,3:4)), na.rm = TRUE, epoch = "2 hours")

}
\references{
Hartmeyer, S.L., Andersen, M. (2023). Towards a framework for
light-dosimetry studies: Quantification metrics. \emph{Lighting Research &
Technology}. \doi{10.1177/14771535231170500}
}
\seealso{
Other metrics: 
\code{\link{bright_dark_period}()},
\code{\link{centroidLE}()},
\code{\link{disparity_index}()},
\code{\link{duration_above_threshold}()},
\code{\link{exponential_moving_average}()},
\code{\link{frequency_crossing_threshold}()},
\code{\link{interdaily_stability}()},
\code{\link{intradaily_variability}()},
\code{\link{midpointCE}()},
\code{\link{nvRC}()},
\code{\link{nvRD}()},
\code{\link{nvRD_cumulative_response}()},
\code{\link{period_above_threshold}()},
\code{\link{pulses_above_threshold}()},
\code{\link{threshold_for_duration}()},
\code{\link{timing_above_threshold}()}
}
\concept{metrics}
