% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeRegime.R
\name{makeRegime}
\alias{makeRegime}
\title{Create a regime (matrix) to program lights to achieve intended irradiances}
\usage{
makeRegime(
  timeVector_POSIXct,
  irradiance_matrix,
  calibration_leds,
  calibration_wavelengths,
  calibration_intensities,
  calibration_irradiances,
  peaks = LightFitR::helio.dyna.leds$wavelength,
  method = "nnls"
)
}
\arguments{
\item{timeVector_POSIXct}{Vector of schedule timepoints in POSICxt format}

\item{irradiance_matrix}{Matrix of intended irradiances. rows = leds and columns = events}

\item{calibration_leds}{A numeric vector of LED values from calibration, mapping to intensities and irradiances (i.e. the same length)}

\item{calibration_wavelengths}{A numeric vector of wavelengths from calibration, corresponding to intensities and irradiances}

\item{calibration_intensities}{A numeric vector of intensities (heliospectra units) from calibration}

\item{calibration_irradiances}{A numeric vector of measured irradiances (any units, as long as it is consistently used) from calibration}

\item{peaks}{Vector of length 8 or 9. Containing wavelengths at which each LED peaks.}

\item{method}{Use 'nnls' (non-negative least squares) or 'sle' (system of linear equations)}
}
\value{
Matrix with light regime needed to program the lights
}
\description{
This is a wrapper function that carries out multiple steps:

1. Calculate closest intensities

2. Predict the intensities to use to achieve the target irradiance (via a system of linear equations or non-negative least squares)

3. Tidy the intensities (rounding to integer, keep within the range of intensities that the lights can be set to)

4. Format the intensities and timestamps into a human-readable regime matrix
}
\section{NNLS vs SLE}{


NNLS and SLE largely predict the same intensities, except in outlier cases. The default is NNLS, but if your predicted intensities end up being very far off, try SLE.
}

\examples{
# Prep variables
calib <- LightFitR::calibration
times <- LightFitR::time_vector
target_irradiance <- LightFitR::target_irradiance

# Run function
makeRegime(times, target_irradiance, calib$led, calib$wavelength, calib$intensity, calib$irradiance)


}
