% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.closestIntensities.R
\name{internal.closestIntensities}
\alias{internal.closestIntensities}
\title{Internal function. Find the intensities corresponding to the closest irradiance match between intended and calibration.}
\usage{
internal.closestIntensities(
  irradiance_matrix,
  calibration_df,
  peaks = LightFitR::helio.dyna.leds$wavelength
)
}
\arguments{
\item{irradiance_matrix}{Matrix of intended irradiances. rows = leds and columns = events}

\item{calibration_df}{Dataframe of calibration data generated by internal.calibCombine}

\item{peaks}{Vector of length 8 or 9. Containing wavelengths at which each LED peaks.}
}
\value{
Matrix of closest intensities, in the same format as `irradiance_matrix`
}
\description{
Internal function. Find the intensities corresponding to the closest irradiance match between intended and calibration.
}
\examples{

# Format calibration data correctly
calib <- LightFitR::calibration[, c(3, 5, 4, 6)]

# Run function
internal.closestIntensities(LightFitR::target_irradiance, calib)

}
