% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifertable.R, R/print.lifertable.R,
%   R/print.lifertableCIBootstrap.R, R/print.lifertableCIJackknife.R,
%   R/print.lifertableLFT.R, R/print.lifertableParmEst.R,
%   R/print.lifertableTest.R, R/print.lifertableTotEggs.R
\name{lifertable}
\alias{lifertable}
\alias{print.lifertable}
\alias{print.lifertableCIBootstrap}
\alias{print.lifertableCIJackknife}
\alias{print.lifertableLFT}
\alias{print.lifertableParmEst}
\alias{print.lifertableTest}
\alias{print.lifertableTotEggs}
\title{Life and Fertility Table}
\usage{
lifertable(
  ColumnFemale,
  ColumnAge,
  ColumnEggs,
  SexRate,
  Survival = 1,
  ColumnGroups,
  data,
  adultStage = 0,
  CI = FALSE,
  technique = "jackknife",
  reSamples = 1000,
  TotalEggs = FALSE
)

\method{print}{lifertable}(x, ...)

\method{print}{lifertableCIBootstrap}(x, title = TRUE, ...)

\method{print}{lifertableCIJackknife}(x, title = TRUE, ...)

\method{print}{lifertableLFT}(x, ...)

\method{print}{lifertableParmEst}(x, ...)

\method{print}{lifertableTest}(x, ...)

\method{print}{lifertableTotEggs}(x, ...)
}
\arguments{
\item{ColumnFemale}{Data vector containing information on Females.}

\item{ColumnAge}{Data vector containing information on Age.}

\item{ColumnEggs}{Data vector containing information on the Number of Eggs Laid.}

\item{SexRate}{Sex rate of eggs laid by the female at a certain age.}

\item{Survival}{Percent of offspring females alive until adulthood. By default,
the value is set to 1, assuming that all offspring will survive to adulthood.}

\item{ColumnGroups}{Optional data vector containing information on the Groups.
It is optional if the database only contains information about one group.}

\item{data}{An optional data frame containing the variables. If not found in
\code{data}, the variables are taken from environment.}

\item{adultStage}{Age at which females became adults.
If the database contains records from birth, entering this value is
unnecessary. \bold{ONLY ENTER THIS VALUE} if the database begins from the
adult stage, and the values in \code{ColumnAge} do not reflect the
preceding stage (i.e. they contain the ages: 1, 2, 3, ...).}

\item{CI}{Logical. If \code{TRUE}, estimations will be conducted to
obtain Confidence Intervals for the Parameters and, if necessary, to compare
between groups. Default is FALSE.}

\item{technique}{A string that defines the technique to be used to calculate the
confidence interval. Can be "\code{jackknife}" or "\code{bootstrap}".
Default is "jackknife".}

\item{reSamples}{Number of re-samples to calculate Bootstrap estimates.
Only used when \code{technique = "bootstrap"}. Default is 1000.}

\item{TotalEggs}{Logical. If  \code{TRUE}, the calculation of the number of
eggs laid by each female during the entire experiment will be conducted.
Default is FALSE.}

\item{x}{Object to be displayed.}

\item{...}{Additional arguments to be passed to or from methods.}

\item{title}{If \code{TRUE} (the default), displays the title of the object (this is for internal use only).}
}
\value{
\code{lifertable} returns an object of \code{\link[base:class]{class}} "lifertable".

An object of class "lifertable" is a list containing the following components:

\item{LIFERTABLE  }{ An object of class \code{lifertableLFT} containing the
Life and Fertility Table.}
\item{PARAMETERS  }{ An object of class \code{lifertableParmEst} containing the
Parameter Estimations}

\item{TOTAL.EGGS  }{ If requested, an object of class \code{lifertableTotEggs}
containing the total number of eggs laid by each female throughout the
entire experiment.}
\item{CI  }{ If requested, an object of class \code{lifertableCIJackknife} or
\code{lifertableCIBootstrap} containing the Confidence Intervals for the
Parameter Estimates.}

\item{T.TEST  }{ An object of class \code{lifertableTest} containing the
Student t-test for pairwise group comparison. This component only appears
if the experiment in question contains more than one group and an
estimate of the Confidence Interval has been performed.}

\item{PSEUDOS  }{ A list containing the pseudo values generated from the
Jackknife or Bootstrap estimation.}
\item{GROUPS  }{ A list of the groups involved in the experiment.}
}
\description{
This function enables users to obtain Life and Fertility Tables, offering
various configuration options for optimal usage. See "Details" section.
}
\details{
\code{ColumnFemale} and \code{ColumnGroups} can be either a numeric vector or
a character vector. This means they may contain either numerical values or
labels corresponding to the female and to their respective group assignments.

The standard approach for storing the Sex Rate and Survival rate during the
experiment is to input this information into the corresponding columns for
each variable. If this information remains consistent within a group, you can
input that value without repeating it each time. If your database encompasses
a single experimental group, simply enter the corresponding value in the
\code{SexRate} and \code{Survival} arguments. In the case of having more than
one group, you can input the values of \code{SexRate} and \code{Survival}
correspondingly into a vector containing as many elements as there are groups
(one sex ratio and one survival rate for each group).

A similar situation applies to \code{adultStage}: you can enter either
a single value or a vector of values corresponding to the involved groups.

\bold{Estimated Parameters:}
\describe{
\item{\emph{Net Reproductive Rate (Ro)}}{ Mean net contribution per female
to the next generation.}
\item{\emph{Intrinsic Rate of Increase (Rm)}}{ Rate of natural increase
in a closed population that has been subject to a constant
age-specific schedule of fertility and mortality for a long period,
and has converged to be a stable population.}
\item{\emph{Mean Generation Time (GT)}}{ Mean time span between the birth
of individuals of a generation and that of the next generation.}
\item{\emph{Doubling Time (DT)}}{ Time span necessary for doubling the
initial population.}
\item{\emph{Finite Rate of Increase (Lambda)}}{ It is a multiplication
factor of the original population at each time period.}
}

\bold{Rm} it was determined by analytical approximation using Lotka’s (1907, 1913) equation:

\deqn{\sum_{x=0}^{\infty}{\exp^{-R_{m}x}l_x m_x} = 1 }
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(lifertable)}: Print a \code{lifertable} object

}}
\section{Functions}{
\itemize{
\item \code{print(lifertableCIBootstrap)}: Print a \code{lifertableCIBootstrap} object, this is the object showing the Confidence Interval obtained with Bootstrap.

\item \code{print(lifertableCIJackknife)}: Print a \code{lifertableCIJackknife} object, this is the object showing the Confidence Interval obtained with Jackknife.

\item \code{print(lifertableLFT)}: Print a \code{lifertableLFT} object, this is the object showing the Life and Fertility Table

\item \code{print(lifertableParmEst)}: Print a \code{lifertableParmEst} object, this is the object showing the Estimated Parameters

\item \code{print(lifertableTest)}: Print a \code{lifertableTest} object, this is the object showing the Student t - test

\item \code{print(lifertableTotEggs)}: Print a \code{lifertableTotEggs} object, this is the object showing the Eggs laid per Female

}}
\examples{
## The Insects database will be utilized:

lifertable(ColumnFemale = Female,
           ColumnAge = Age,
           ColumnEggs = Eggs,
           SexRate = Sexrate,
           Survival = Survival,
           ColumnGroups = Group,
           data = Insects,
           CI = TRUE,
           technique = "jackknife",
           TotalEggs = TRUE)

## The following expressions will yield the same result as above:

## lifertable(ColumnFemale = Insects$Female,
##            ColumnAge = Insects$Age,
##            ColumnEggs = Insects$Eggs,
##            SexRate = Insects$Sexrate,
##            Survival = Insects$Survival,
##            ColumnGroups = Insects$Group,
##            CI = TRUE, technique = "jackknife",
##            TotalEggs = TRUE)

## lifertable(ColumnFemale = Insects$Female,
##            ColumnAge = Insects$Age,
##            ColumnEggs = Insects$Eggs,
##            SexRate = 0.7, Survival = 0.9,
##            ColumnGroups = Insects$Group,
##            CI = TRUE, technique = "jackknife",
##            TotalEggs = TRUE)

## lifertable(ColumnFemale = Insects$Female,
##            ColumnAge = Insects$Age,
##            ColumnEggs = Insects$Eggs,
##            SexRate = c(0.7, 0.7),
##            Survival = c(0.9, 0.9),
##            ColumnGroups = Insects$Group,
##            CI = TRUE, technique = "jackknife",
##            TotalEggs = TRUE)


}
\references{
Maia, A. H., Luis, A. J., & Campanhola, C. (2000).
"Statistical Inference on Associated Fertility Life Table Parameters Using
Jackknife Technique: Computational Aspects". \emph{Journal of Economic Entomology},
93(2), 511-518.
\doi{https://doi.org/10.1603/0022-0493-93.2.511}

Portilla, M., Morales-Ramos, J. A., Guadalupe Rojas, M., & Blanco, C. A. (2014).
"Chapter 8 - Life Tables as Tools of Evaluation and Quality Control for Arthropod
Mass Production". \emph{Mass Production of Beneficial Organisms} (241-275).
\doi{https://doi.org/10.1016/B978-0-12-391453-8.00008-X}
}
