% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexis_lifeline.R
\name{lexis_lifeline}
\alias{lexis_lifeline}
\title{Plot lifelines into a Lexis grid}
\usage{
lexis_lifeline(lg, birth, entry = NA, exit = NA, lineends = FALSE,
  colour = lexisplotr_colours()[5], alpha = 1, lwd = 0.5)
}
\arguments{
\item{lg, }{an existing object originally created with \code{lexis_grid()}.}

\item{birth}{character, set the birth date of an individual in format \code{"YYYY-MM-DD"}.}

\item{entry}{character, set the entry of an individual in format \code{"YYYY-MM-DD"}. Optional.}

\item{exit}{character, set the exit or death date of an individual in format \code{"YYYY-MM-DD"}. Optional.}

\item{lineends}{logical, if \code{TRUE} lineends will be marked. Default is \code{FALSE}.}

\item{colour}{character, set the colour of the lifelines.}

\item{alpha}{numeric, set the transparency of the lifelines. Default is \code{1} (no transparency).}

\item{lwd}{numeric, set the linewidth of the lifelines. Default is \code{0.5}.}
}
\value{
A ggplot2 object.
}
\description{
Add lifelines to an existing Lexis grid.
}
\details{
Takes an existing Lexis grid and adds lifelines to the grid. Input can be a single dates or dates from a vector.
}
\examples{
lg <- lexis_grid(year_start = 1900, year_end = 1905, age_start = 0, age_end = 5)
lexis_lifeline(lg = lg, birth = "1901-09-23")
lexis_lifeline(lg = lg, birth = "1901-09-23", entry = "1902-04-01")
lexis_lifeline(lg = lg, birth = "1901-09-23", exit = "1904-10-31")
}
\author{
Philipp Ottolinger
}
