% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exponential.R
\name{plotExp}
\alias{plotExp}
\title{Density Function, Distribution Function and/or
Quantile Function Representations associated with a Exponential Distribution}
\usage{
plotExp(lambda, type = "b", col = "black")
}
\arguments{
\item{lambda}{the parameter of the Exponential distribution (1/mean).}

\item{type}{a character string giving the type of desired plot. The following values are possible:
"b" (default) for density function, distribution function and quantile function representations together,
"dis" for distribution function representation,
"den" for density function representation and "q" for quantile function representation.}

\item{col}{a single colour associated with the different representations; default to "black".}
}
\value{
This function is called for the side effect of drawing the plot.
}
\description{
\code{plotExp} represents density, distribution and/or quantile functions associated with a Exponential
 distribution with certain parameter \code{lambda}.
}
\examples{
lambda=0.5
plotExp(lambda)
plotExp(lambda,col="red")
plotExp(lambda,type="q")
plotExp(lambda,type="dis")
plotExp(lambda,type="den")
}
