% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.table.R
\name{freq.table}
\alias{freq.table}
\title{Frequency Table}
\usage{
freq.table(x, cont, ord = NULL)
}
\arguments{
\item{x}{a vector containing the sample provided to compute the frequency table}

\item{cont}{logical; if TRUE, the sample comes from a continuous variable; if FALSE the sample is treated as coming from a discrete or categorical variable.}

\item{ord}{if needed, character vector containing the ordered categories' names of the ordinal variable.}
}
\value{
A list containing the following components:
\item{ni}{a numeric vector containing the absolute frequencies.}
\item{fi}{a numeric vector containing the relative frequencies.}
\item{Ni}{a numeric vector containing the absolute cumulative frequencies.}
\item{Fi}{a numeric vector containing the relative cumulative frequencies.}
\item{di}{if cont=TRUE, a vector containing the frequency density.}
\item{tab}{the frequency table.}
The values of the cumulative frequencies (Ni and Fi) are only computed and provided when the variable of interest is ordered.
If the user does not save those values, the function provides the list on the console.
}
\description{
The function \code{freq.table} computes a frequency table with absolute and relative frequencies (for non-ordered variables); and with those as well as their cumulative counterparts (for ordered variables).
}
\details{
The procedure used to define the intervals for the frequency table in the continuous case is the same as used for the histogram (see ?Histogram).
}
\examples{
#Nominal variable
x=sample(c("yellow","red","blue","green"),size=20,replace=TRUE)
freq.table(x,cont=FALSE)

#Ordinal variable
x=sample(c("high","small","medium"),size=20,replace=TRUE)
freq.table(x,cont=FALSE,ord=c("small","medium","high"))

#Discrete variable
x=sample(1:5,size=20,replace=TRUE)
freq.table(x,cont=FALSE)

#Continuous variable
x=rnorm(20)
freq.table(x,cont=TRUE)

}
