% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Koch.R
\name{Koch}
\alias{Koch}
\title{Plots the Koch curve}
\usage{
Koch(P1, P2, it)
}
\arguments{
\item{P1}{Vector containing the xy-coordinates of point 1. This point is the left extreme of the segment that corresponds to the first iteration (\code{it} = 1)}

\item{P2}{Vector containing the xy-coordinates of point 2. This point is the right extreme of the segment that corresponds to the first iteration (\code{it} = 1)}

\item{it}{Number of iterations to be performed for the construction of Koch curve. It is not recommended to choose a number higher than 7 in order to avoid an excess of computation}
}
\value{
None. It produces the plot of the first \code{n} iterations of Koch curve in the current coordinate plane
}
\description{
\code{Koch} plots the first iterations of Koch curve, a well-known fractal
}
\examples{
x_min <- -6
x_max <- 6
y_min <- -4
y_max <- 8
CoordinatePlane(x_min, x_max, y_min, y_max)
P1 <- c(-5,0)
P2 <- c(5,0)
it <- 4 
Koch(P1, P2, it)
}
\references{
http://mathworld.wolfram.com/KochSnowflake.html
}
