% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.LassoGEE.R
\name{cv.LassoGEE}
\alias{cv.LassoGEE}
\title{Cross-validation for LassoGEE.}
\usage{
cv.LassoGEE(
  X,
  y,
  id,
  family,
  method = c("CGD", "RWL"),
  scale.fix,
  scale.value,
  fold,
  lambda.vec,
  maxiter,
  tol
)
}
\arguments{
\item{X}{A design matrix of dimension  \code{(nm) * p}.}

\item{y}{A response vector of length  \code{m * n}.}

\item{id}{A vector for identifying subjects/clusters.}

\item{family}{A family object: a list of functions and expressions
for defining link and variance functions. Families supported here is same as
  in \pkg{PGEE} which are binomial, gaussian, gamma and poisson.}

\item{method}{The algorithms that are available. \code{"CGD"} represents the
I-CGD algorithm, and \code{"RWL"} represents re-weighted least square algorithm.}

\item{scale.fix}{A logical variable; if true, the scale parameter is
fixed at the value of scale.value. The default value is TRUE.}

\item{scale.value}{If  \code{scale.fix = TRUE}, this assignes a
numeric value to which the scale parameter should be fixed.
The default value is 1.}

\item{fold}{The number of folds used in cross-validation.}

\item{lambda.vec}{A vector of tuning parameters that will be used in the
cross-validation.}

\item{maxiter}{The number of iterations that is used in the estimation algorithm.
The default value is \code{50}.}

\item{tol}{The tolerance level that is used in the estimation algorithm.
The default value is \code{1e^-3}.}
}
\value{
An object class of cv.LassoGEE.
}
\description{
Does k-fold cross-validation for LassoGEE to select tuning parameter
value for longitudinal data with working independence structure.
}
\references{
Li, Y., Gao, X., and Xu, W. (2020). Statistical consistency for
generalized estimating equation with \eqn{L_1} regularization.
}
\seealso{
LassoGEE
}
