% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulate_under_LTM.R
\name{simulate_under_LTM_single}
\alias{simulate_under_LTM_single}
\title{Simulate under the liability threshold model (single phenotype).}
\usage{
simulate_under_LTM_single(
  fam_vec = c("m", "f", "s1", "mgm", "mgf", "pgm", "pgf"),
  n_fam = NULL,
  add_ind = TRUE,
  h2 = 0.5,
  n_sim = 1000,
  pop_prev = 0.1
)
}
\arguments{
\item{fam_vec}{A vector of strings holding the different
family members. All family members must be represented by strings from the
following list:
\itemize{
\item \code{m} (Mother)
\item \code{f} (Father)
\item \code{c[0-9]*.[0-9]*} (Children)
\item \code{mgm} (Maternal grandmother)
\item \code{mgf} (Maternal grandfather)
\item \code{pgm} (Paternal grandmother)
\item \code{pgf} (Paternal grandfather)
\item \code{s[0-9]*} (Full siblings)
\item \code{mhs[0-9]*} (Half-siblings - maternal side)
\item \code{phs[0-9]*} (Half-siblings - paternal side)
\item \code{mau[0-9]*} (Aunts/Uncles - maternal side)
\item \code{pau[0-9]*} (Aunts/Uncles - paternal side).
Defaults to \code{c("m","f","s1","mgm","mgf","pgm","pgf")}.
}}

\item{n_fam}{A named vector holding the desired number of family members.
See  \code{\link[stats]{setNames}}.
All names must be picked from the list mentioned above. Defaults to \code{NULL}.}

\item{add_ind}{A logical scalar indicating whether the genetic
component of the full liability as well as the full
liability for the underlying target individual should be included in
the covariance matrix. Defaults to \code{TRUE}.}

\item{h2}{A number representing the liability-scale heritability
for a single phenotype. Must be non-negative. Note that under
the liability threshold model, the heritability must also be at most 1.
Defaults to 0.5.}

\item{n_sim}{A positive number representing the number of simulations. Defaults to 1000.}

\item{pop_prev}{A positive number representing the population prevalence, i.e. the
overall prevalence in the population. Must be smaller than 1. Defaults to 0.1.}
}
\value{
If either \code{fam_vec} or \code{n_fam} is used as the argument,
if it is of the required format, if the liability-scale heritability \code{h2}
is a number satisfying \eqn{0 \leq h^2}, \code{n_sim} is a strictly positive number,
and \code{pop_prev} is a positive number that is at most one,
then the output will be a list holding two tibbles.
The first tibble, \code{sim_obs}, holds the simulated liabilities, the disease
status and the current age/age-of-onset for all family members in each of the
\code{n_sim} families.
The second tibble, \code{thresholds}, holds the family identifier, the personal
identifier, the role (specified in fam_vec or n_fam) as well as
the lower and upper thresholds for all individuals in all families.
Note that this tibble has the format required in \code{\link{estimate_liability}}.
In addition, note that if neither \code{fam_vec} nor \code{n_fam} are specified, the function
returns the disease status, the current age/age-of-onset, the lower and upper
thresholds, as well as the personal identifier for a single individual, namely
the individual under consideration (called \code{o}).
If both \code{fam_vec} and \code{n_fam} are defined, the user is asked to '
decide on which of the two vectors to use.
}
\description{
\code{simulate_under_LTM_single} simulates families and thresholds under
the liability threshold model for a given family structure and a single
phenotype. Please note that it is not possible to simulate different
family structures.
}
\examples{
simulate_under_LTM_single()
simulate_under_LTM_single(fam_vec = NULL, n_fam = stats::setNames(c(1,1,1,2), 
c("m","mgm","mgf","mhs")))
simulate_under_LTM_single(fam_vec = c("m","f","s1"), n_fam = NULL, add_ind = FALSE, 
h2 = 0.5, n_sim = 500, pop_prev = .05)
simulate_under_LTM_single(fam_vec = c(), n_fam = NULL, add_ind = TRUE, h2 = 0.5, 
n_sim = 200, pop_prev = 0.05)

}
\seealso{
\code{\link{construct_covmat}}, \code{\link{simulate_under_LTM_multi}}, \code{\link{simulate_under_LTM}}
}
