% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prepare_Graph_Input.R
\name{get_family_graphs}
\alias{get_family_graphs}
\title{Automatically identify family members of degree n}
\usage{
get_family_graphs(
  pop_graph,
  ndegree,
  proband_vec,
  fid = "fid",
  fam_graph_col = "fam_graph",
  mindist = 0,
  mode = "all"
)
}
\arguments{
\item{pop_graph}{Population graph from prepare_graph()}

\item{ndegree}{Number of steps away from proband to include}

\item{proband_vec}{Vector of proband ids to create family graphs for. Must be strings.}

\item{fid}{Column name of proband ids in the output.}

\item{fam_graph_col}{Column name of family graphs in the output.}

\item{mindist}{Minimum distance from proband to exclude in the graph (experimental, untested), defaults to 0, passed directly to make_neighborhood_graph.}

\item{mode}{Type of distance measure in the graph (experimental, untested), defaults to "all", passed directly to make_neighborhood_graph.}
}
\value{
Tibble with two columns, family ids (fid) and family graphs (fam_graph_col).
}
\description{
This function identifies individuals ndegree-steps away from the proband in the population graph.
}
\examples{
# See Vignettes.
}
