% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSWPsim.R
\name{LSWPsim}
\alias{LSWPsim}
\title{Simulation of LSWP processes}
\usage{
LSWPsim(bb, spec, lev, wavelet, N)
}
\arguments{
\item{bb}{a wavelet packet basis for the simulated process.}

\item{spec}{a (locally stationary) spectra corresponding to the wavelet packet basis.}

\item{lev}{the maximum level of the basis that is considered for simulation. Usually this is set as the maximum level in \code{bb}.}

\item{wavelet}{the Daubechies wavelet used to build wavelet packets to simulate the process. See also Details.}

\item{N}{the number of realizations to be simulated.}
}
\value{
If \code{N = 1} the function returns a vector containing the simulated time series.
If \code{N > 1} the function returns a matrix with \code{N} columns each containing a different
simulated series.
}
\description{
\code{LSWPsim} returns simulated time series from a specified LSWP specification.
}
\details{
This function produces one or multiple realizations of an LSWP process that is
specified in terms of a wavelet packet basis and its corresponding spectra.

The function simulates realizations accordingly to the specified arguments.
The wavelet argument is specified as in other functions of this package.
Therefore, the current implementation allows for three discrete wavelets: Haar (\code{"haar"}),
Daubechies Extremal Phase linear filters of length 4 (\code{"d4"}) and Least Asymmetric linear filters of length 8 (\code{"la8"}).
}
\examples{

wwb <- get.flat.basis(scale = 4)
wwp <- matrix(2^{-(1:4)}, nrow = 4, ncol = 512, byrow = FALSE)
xt <- LSWPsim(bb = wwb, spec = wwp, lev = 4, wavelet = 'la8', N = 10)

}
\references{
A. Cardinali and G.P. Nason (2017). Locally Stationary Wavelet Packet Processes:
            Basis Selection and Model Fitting. Journal of Time Series Analysis, 38:2, 151-174.
}
\seealso{
\code{\link{LSWPspec}}, \code{\link{best.basis}}, \code{\link{get.flat.basis}}, \code{\link{get.wavelet.basis}}.
}
\author{
Alessandro Cardinali
}
