% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_plot.R
\name{point_plot}
\alias{point_plot}
\title{One-step data graphics}
\usage{
point_plot(
  D,
  tilde,
  ...,
  seed = 101,
  annot = c("none", "violin", "model", "bw"),
  jitter = c("default", "none", "all", "x", "y"),
  interval = c("confidence", "none", "prediction"),
  point_ink = 0.5,
  model_ink = 0.4,
  palette = LETTERS[1:8],
  bw = NULL,
  level = 0.95,
  nx = 50,
  model_family = NULL
)
}
\arguments{
\item{D}{a data frame}

\item{tilde}{tilde expression specifying \code{y ~ x} or \code{y ~ x + color}}

\item{seed}{(optional) random seed for jittering}

\item{annot}{Statistical annotation (one of "none", "violin", "model", "bw")}

\item{jitter}{Options for turning on jitter: one of \code{"default"}, \code{"both"}, \code{"none"}, \code{"x"}, \code{"y"}. By default,
By default, categorical variables are jittered.}

\item{interval}{the type of interval: default \code{"confidence"}. Others: \code{"none"} or \code{"prediction"}}

\item{point_ink}{Opacity of ink for the data points}

\item{model_ink}{Opacity of ink for the model annotation}

\item{palette}{Depending on taste and visual capabilities, some people might
prefer to alter the color scheme. There are 8 palettes available: \code{"A"} through \code{"H"}.}

\item{bw}{bandwidth for violin plot}

\item{level}{confidence level to use (0.95)}

\item{nx}{Number of places to evaluate any x-axis quantitative vars. Default 50. Use higher
if graph isn't smooth enough.}

\item{model_family}{Override the default model type. See \code{model_train()}}

\item{\ldots}{Graphical options for the data points, labels, e.g. size}
}
\value{
A ggplot graphics object
}
\description{
\code{point_plot()} makes it easy to construct an informative basic graph of a
data frame. "Making it easy" means that the user only needs to specify
two things: 1) the data frame to be used and 2) a tilde expression with the response variable on the left and up to
three explanatory variables on the right. The response variable is mapped to
the vertical axis while the first explanatory variable defines
the horizontal axis. The second explanatory variable (if any) maps to color,
the third (if any) defines facets. Quantitative variables used for color or faceting
are cut into categorical variables, so color and facets will always be discrete.
}
\details{
When an x- or y- variables is categorical, jittering is automatically applied.

Using \code{annot = "model"} will annotate the data with the graph of a
model --- shown as confidence intervals/bands --- corresponding to
the tilde expression. \code{annot = "violin"} will annotate with a violin plot.

If you want to use the same explanatory variable for color and faceting
(this might have pedagogical purposes) merely repeat the name of the color variable
in the faceting position, e.g. \code{mpg ~ hp + cyl + cyl}.
}
\examples{
mosaicData::Galton |> point_plot(height ~ mother + sex + father, annot="model", model_ink=1)
mtcars |> point_plot(mpg ~ wt + cyl)
mtcars |> point_plot(mpg ~ wt + cyl + hp, annot="model")
}
\seealso{
\code{add_plot_labels} to add labels to the plot (without needing the ggplot2 + pipe)
}
