% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_plot.R
\name{model_plot}
\alias{model_plot}
\title{Graph a model function}
\usage{
model_plot(
  mod,
  nlevels = 3,
  interval = c("confidence", "prediction", "none"),
  level = 0.95,
  palette = LETTERS[1:8],
  model_ink = 0.7
)
}
\arguments{
\item{mod}{A model object, made with \code{model_train()}, \code{lm()}, or \code{glm()}}

\item{nlevels}{Integer. When quantitative variables need to be converted to
factors for color or facetting, how many levels in those factors.}

\item{interval}{The type of interval to draw (default: confidence)}

\item{level}{The confidence or prediction level for the interval}

\item{palette}{One of "A" through "F" giving some control for people who don't like or can't see the default palette}

\item{model_ink}{The density of ink used to draw the model. ("alpha" for those in the know.)}
}
\value{
A ggplot graphics object
}
\description{
Every model has an implicit function whose output is the response variable and which has one
or more explanatory variables. (Exceptionally, there might be no explanatory variables as in
\code{response ~ 1}.) One of the explanatory variables can be mapped to the horizontal axis; this can
be either quantitative or categorical. The remaining explanatory variables will be mapped to color,
facet-horizontal, and facet-vertical. For visual clarity, any quantitative
variables among these remaining variables must be coerced
to categorical, corresponding to a discrete set of colors and a discrete set of facets.
}
