% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Registrar.R
\docType{data}
\name{Registrar}
\alias{Registrar}
\alias{Sessions}
\alias{Grades}
\alias{Gradepoint}
\title{Sample from a college registrar's database}
\format{
Three data frames
\itemize{
\item Sessions: ID for a class session, that is, a course in a semester
\itemize{
\item sessionID: Unique identifier for the session
\item iid: Unique identifier for the instructor
\item enroll: Total enrollment in the session (note: includes students who didn't make it into the sample in \code{Grades})
\item dept: Unique identifier for the department
\item level: Instruction evel of the course 100, 200, 300, 400. Roughly: first-year, sophomore, junior, senior
\item sem: The semester in which the session was held.
}
\item Grades: A 50\% random sample of student-by-student grades in those Sessions
\itemize{
\item sid: Unique identifier or the student.
\item grade: Letter grade: A, A-, B+ and so on,
\item sessionID: The course session for the grade, as in the Sessions data frame
}
\item Gradepoint: Letter to numerical conversion (per college policy)
\itemize{
\item grade: Letter grade: A, A-, and so on
\item gradepoint: Numerical equivalent
}
}

An object of class \code{data.frame} with 6124 rows and 3 columns.

An object of class \code{grouped_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 14 rows and 2 columns.
}
\source{
Used with permission by the college's registrar.
}
\usage{
Sessions

Grades

Gradepoint
}
\description{
Grade data from students at a liberal arts college. IDs of students,
professors, and departments have been dis-identified.
}
\keyword{datasets}
