% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_whittle_loglik.R
\name{LS.whittle.loglik}
\alias{LS.whittle.loglik}
\title{Locally Stationary Whittle log-likelihood Function}
\usage{
LS.whittle.loglik(
  x,
  series,
  order = c(p = 0, q = 0),
  ar.order = NULL,
  ma.order = NULL,
  sd.order = NULL,
  d.order = NULL,
  include.d = FALSE,
  N = NULL,
  S = NULL,
  include.taper = TRUE
)
}
\arguments{
\item{x}{(type: numeric) parameter vector.}

\item{series}{(type: numeric) univariate time series.}

\item{order}{(type: numeric) vector corresponding to \code{ARMA} model
entered.}

\item{ar.order}{(type: numeric) AR polimonial order.}

\item{ma.order}{(type: numeric) MA polimonial order.}

\item{sd.order}{(type: numeric) polinomial order noise scale factor.}

\item{d.order}{(type: numeric) \code{d} polinomial order, where \code{d} is
the \code{ARFIMA} parameter.}

\item{include.d}{(type: numeric) logical argument for \code{ARFIMA} models.
If \code{include.d=FALSE} then the model is an ARMA process.}

\item{N}{(type: numeric) value corresponding to the length of the window to
compute periodogram. If \code{N=NULL} then the function will use
\eqn{N = \textrm{trunc}(n^{0.8})}, see Dahlhaus (1998) where \eqn{n} is the
length of the \code{y} vector.}

\item{S}{(type: numeric) value corresponding to the lag with which will go
taking the blocks or windows.}

\item{include.taper}{(type: logical) logical argument that by default is
\code{TRUE}. See \code{\link{periodogram}}.}
}
\description{
This function computes Whittle estimator for LS-ARMA and
LS-ARFIMA models, in data with mean zero. If mean is not zero, then it is
subtracted to data.
}
\details{
The estimation of the time-varying parameters can be carried out by means of
the Whittle log-likelihood function proposed by Dahlhaus (1997),
\deqn{L_n(\theta) = \frac{1}{4\pi}\frac{1}{M} \int_{-\pi}^{\pi}
\bigg\{log f_{\theta}(u_j,\lambda) +
\frac{I_N(u_j, \lambda)}{f_{\theta}(u_j,\lambda)}\bigg\}\,d\lambda}
where \eqn{M} is the number of blocks, \eqn{N} the length of the series per
block, \eqn{n =S(M-1)+N}, \eqn{S} is the shift from block to block,
\eqn{u_j =t_j/n}, \eqn{t_j =S(j-1)+N/2}, \eqn{j =1,\ldots,M} and
\eqn{\lambda} the Fourier frequencies in the block
(\eqn{2\,\pi\,k/N}, \eqn{k = 1,\ldots, N}).
}
\references{
For more information on theoretical foundations and estimation methods see
\insertRef{brockwell2002introduction}{LSTS}
\insertRef{palma2010efficient}{LSTS}
}
\seealso{
\code{\link[stats]{nlminb}}, \code{\link{LS.kalman}}
}
