#' Plot LSTM Classification Probability Distribution
#'
#' @description
#' This function generates a bar plot of the classification probabilities predicted by the pre-trained LSTM
#' for determining the number of factors. The plot displays the probability distribution across different numbers of factors,
#' with each bar representing the probability for a specific number of factors. The maximum number of factors that the network
#' can evaluate is 10. The function also annotates each bar with its probability value.
#' @seealso \code{\link[LSTMfactors]{LSTM}}
#'
#' @param x An object of class \code{LSTM}, representing the results to be plotted.
#' @param ... Additional arguments to be passed to the plotting function.
#' @return None. This function is used for side effects (plotting).
#'
#' @importFrom grDevices gray.colors
#' @importFrom graphics plot abline axis barplot legend lines mtext par pie points text
#' @export
plot.LSTM <- function(x, ...) {
  obj <- x

  probability <- obj$probability
  bp <- barplot(probability,
                beside = TRUE,
                col = gray.colors(ncol(probability)),
                xlab = "Number of Factor",
                ylab = "Probability",
                main = paste0("Long Short Term Memory Network", "\nProbability Distribution of the Number of Factors"),
                ylim = c(0, max(probability) * 1.1),
                las = 2)

  text(x = bp, y = probability, label = round(probability, digits = 3),
       pos = 3, cex = 0.8, col = "black")
  axis(1, at = bp, labels = 1:ncol(probability))

}
