% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_mu_tests.R
\name{empirical_mu_one_way}
\alias{empirical_mu_one_way}
\title{Test the equality of means of an unknown distribution.}
\source{
\itemize{
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Owen. Empirical Likelihood. Chapman & Hall/CRC.
}
}
\usage{
empirical_mu_one_way(x, fctr, conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector.}

\item{fctr}{a factor vector indicating groups.}

\item{conf.level}{overall confidence level of the likelihood intervals. Uses Bonferroni correction.}
}
\value{
An S3 class containing the test statistic, p value, list of likelihood based confidence intervals,
overall confidence level, individual confidence level of each interval and alternative
hypothesis.
}
\description{
Test the equality of means of an unknown distribution.
}
\details{
\itemize{
\item Null: All mus are equal. (mu1 = mu2 ... muk).
\item Alternative: At least one mu is not equal.
}
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rnorm(75, 1, 1)
fctr <- c(rep(1, 25), rep(2, 25), rep(3, 25))
fctr <- factor(fctr, levels = c("1", "2", "3"))
empirical_mu_one_way(x, fctr, .95)

# Null is false
set.seed(1)
x <- c(rnorm(25, 1, 1), rnorm(25, 2, 1), rnorm(25, 3, 1))
fctr <- c(rep(1, 25), rep(2, 25), rep(3, 25))
fctr <- factor(fctr, levels = c("1", "2", "3"))
empirical_mu_one_way(x, fctr, .95)
}
