% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cauchy_tests.R
\name{cauchy_scale_one_sample}
\alias{cauchy_scale_one_sample}
\title{Test the scale parameter of a cauchy distribution.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
cauchy_scale_one_sample(x, scale, alternative = "two.sided", conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of data.}

\item{scale}{a number indicating the tested value of the scale parameter.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test the scale parameter of a cauchy distribution.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rcauchy(n = 100, location = 1, scale = 2)
cauchy_scale_one_sample(x, 2, "two.sided")

# Null is false
set.seed(1)
x <- rcauchy(n = 100, location = 3, scale = 2)
cauchy_scale_one_sample(x, 1, "greater")
}
