% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{points2img}
\alias{points2img}
\title{points2img}
\usage{
points2img(points, voxel.size, method, channels = NULL, ncpu = 1)
}
\arguments{
\item{points}{a point set as a data frame of coordinates with columns x,y,z.}

\item{voxel.size}{a numeric vector of length 3 indicating the size of the voxel along x,y and z in the same unit as the coordinates (e.g. nm)}

\item{method}{how to calculate voxel values. Available methods are:
  \itemize{
    \item 'histogram': value is the number of points (i.e. emitters) in the voxel
    \item 'photon': value is the expected number of photons from the points in the voxel. Input data frame must have columns locprec, locprecz and phot[on].
}}

\item{channels}{vector of channels to consider, must be values present in the input data frame channel column}

\item{ncpu}{number of threads to use to speed up computation (default: 1)}
}
\value{
an array of dimensions x,y,z and channels if applicable
}
\description{
Convert a data frame of point coordinates into an image.
Expected photon count at each voxel is computed as in:
F. Huang, S. L. Schwartz, J. M. Byars, and K. A. Lidke, “Simultaneous multiple-emitter fitting for single
molecule super-resolution imaging,” Biomed. Opt. Express 2(5), 1377–1393 (2011).
}
\examples{
point.set <- data.frame(x = c(-9.8,-5.2,12.5,2.5,4.5,1.3,-0.2,0.4,9.3,-1.4,0.5,-1.1,-7.7),
                        y = c(-4.2,1.5,-0.5,12,-3,-7.2,10.9,6.7,-1.3,10,6.7,-6.2,2.9),
                        z = c(3.4,-3.8,-1.4,1.8,3.5,2.5,2.6,-4.8,-3.8,3.9,4.1,-3.6,-4))
img <- points2img(point.set, voxel.size = c(2,2,2), method = 'histogram')
}
