% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{coloc_index}
\alias{coloc_index}
\title{coloc_index}
\usage{
coloc_index(
  P1,
  locprec1 = NULL,
  locprecz1 = NULL,
  P2,
  locprec2 = NULL,
  locprecz2 = NULL
)
}
\arguments{
\item{P1}{a point set as matrix or data frame with columns x,y,z.}

\item{locprec1}{(optional) localization precision in x,y for P1}

\item{locprecz1}{(optional) localization precision along z for P1}

\item{P2}{a point set as matrix or data frame with columns x,y,z.}

\item{locprec2}{(optional) localization precision in x,y for P2}

\item{locprecz2}{(optional) localization precision along z for P2}
}
\value{
a list with two elements:
  \itemize{
    \item vector of co-localization indices for points in P1 relative to P2
    \item vector of co-localization indices for points in P2 relative to P1
  }
}
\description{
Compute a co-localization index between two sets of points. 
Adapted from:
Willems and MacGillavry, A coordinate-based co-localization index to quantify
and visualize spatial associations in single-molecule localization microscopy.
Sci Rep 12, 4676 (2022). https://doi.org/10.1038/s41598-022-08746-4
}
\details{
This can be seen as measuring the similarity between two spatial distributions.
Co-clustering in dense structures can give values above 1.

Localization precision is optional but if used then all locprec parameters
must be specified.
}
