% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qBrXII.R
\name{qBrXII}
\alias{qBrXII}
\title{Quantile distribution function of BrXII distribution}
\usage{
qBrXII(u = NULL, RP = 1/(1 - u), para)
}
\arguments{
\item{u}{non-exceedance probability}

\item{RP}{Return Period "don't use in case u is used"}

\item{para}{parameters as c(scale, shape1, shape2)}
}
\value{
Quantile value/s using the inverse of the cumulative distribution function.
}
\description{
Quantile distribution function of BrXII distribution
}
\examples{

x <- qBrXII(u = 0.99, para = c(1, 10, 0.8))
x <- qBrXII(RP = 100, para = c(1, 10, 0.8))

}
\author{
Mohanad Zaghloul [aut, cre], Simon Michael Papalexiou [aut, ths], Amin Elshorbagy [aut, ths]
}
