% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmn_prior.R
\name{lmn_prior}
\alias{lmn_prior}
\title{Conjugate prior specification for LMN models.}
\usage{
lmn_prior(p, q, Lambda, Omega, Psi, nu)
}
\arguments{
\item{p}{Integer specifying row dimension of \code{Beta}.  \code{p = 0} corresponds to no \code{Beta} in the model, i.e., \code{X = 0} in \code{\link[=lmn_suff]{lmn_suff()}}.}

\item{q}{Integer specifying the dimension of \code{Sigma}.}

\item{Lambda}{Mean parameter for \code{Beta}.  Either:
\itemize{
\item A \verb{p x q} matrix.
\item A scalar, in which case \code{Lambda = matrix(Lambda, p, q)}.
\item Missing, in which case \code{Lambda = matrix(0, p, q)}.
}}

\item{Omega}{Row-wise precision parameter for \code{Beta}.  Either:
\itemize{
\item A \verb{p x p} matrix.
\item A scalar, in which case \code{Omega = diag(rep(Omega,p))}.
\item Missing, in which case \code{Omega = matrix(0, p, p)}.
\item \code{NA}, which signifies that \code{Beta} is known, in which case the prior is purely Inverse-Wishart on \code{Sigma} (see \strong{Details}).
}}

\item{Psi}{Scale parameter for \code{Sigma}.  Either:
\itemize{
\item A \verb{q x q} matrix.
\item A scalar, in which case \code{Psi = diag(rep(Psi,q))}.
\item Missing, in which case \code{Psi = matrix(0, q, q)}.
}}

\item{nu}{Degrees-of-freedom parameter for \code{Sigma}.  Either a scalar, missing (defaults to \code{nu = 0}), or \code{NA}, which signifies that \code{Sigma = diag(q)} is known, in which case the prior is purely Matrix-Normal on \code{Beta} (see \strong{Details}).}
}
\value{
A list with elements \code{Lambda}, \code{Omega}, \code{Psi}, \code{nu} with the proper dimensions specified above, except possibly \code{Omega = NA} or \code{nu = NA} (see \strong{Details}).
}
\description{
The conjugate prior for LMN models is the Matrix-Normal Inverse-Wishart (MNIW) distribution.  This convenience function converts a partial MNIW prior specification into a full one.
}
\details{
The Matrix-Normal Inverse-Wishart (MNIW) distribution \eqn{(\boldsymbol{B}, \boldsymbol{\Sigma}) \sim \textrm{MNIW}(\boldsymbol{\Lambda}, \boldsymbol{\Omega}, \boldsymbol{\Psi}, \nu)}{(B, \Sigma) ~ MNIW(\Lambda, \Omega, \Psi, \nu)} on random matrices \eqn{\boldsymbol{X}_{p \times q}}{X_(p x q)} and symmetric positive-definite \eqn{\boldsymbol{\Sigma}_{q \times q}}{\Sigma_(q x q)} is defined as
\deqn{
\begin{array}{rcl}
\boldsymbol{\Sigma} & \sim & \textrm{Inverse-Wishart}(\boldsymbol{\Psi}, \nu) \\
\boldsymbol{B} \mid \boldsymbol{\Sigma} & \sim & \textrm{Matrix-Normal}(\boldsymbol{\Lambda}, \boldsymbol{\Omega}^{-1}, \boldsymbol{\Sigma}),
\end{array}
}{
\Sigma ~ Inverse-Wishart(\Psi, \nu)
B | \Sigma ~ Matrix-Normal(\Lambda, \Omega^{-1}, \Sigma),
}
where the Matrix-Normal distribution is defined in \code{\link[=lmn_suff]{lmn_suff()}}.
}
\examples{
# problem dimensions
p <- 2
q <- 4

# default noninformative prior pi(Beta, Sigma) ~ |Sigma|^(-(q+1)/2)
lmn_prior(p, q)

# pi(Sigma) ~ |Sigma|^(-(q+1)/2)
# Beta | Sigma ~ Matrix-Normal(0, I, Sigma)
lmn_prior(p, q, Lambda = 0, Omega = 1)

# Sigma = diag(q)
# Beta ~ Matrix-Normal(0, I, Sigma = diag(q))
lmn_prior(p, q, Lambda = 0, Omega = 1, nu = NA)
}
