% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmn_post.R
\name{lmn_post}
\alias{lmn_post}
\title{Parameters of the posterior conditional distribution of an LMN model.}
\usage{
lmn_post(suff, prior)
}
\arguments{
\item{suff}{An object of class \code{lmn_suff} (see \code{\link[=lmn_suff]{lmn_suff()}}).}

\item{prior}{A list with elements \code{Lambda}, \code{Omega}, \code{Psi}, \code{nu} as returned by \code{\link[=lmn_prior]{lmn_prior()}}.}
}
\value{
A list with elements named as in \code{prior} specifying the parameters of the posterior MNIW distribution.  Elements \code{Omega = NA} and \code{nu = NA} specify that parameters \code{Beta = 0} and \code{Sigma = diag(q)}, respectively, are known and not to be estimated.
}
\description{
Calculates the parameters of the LMN model's Matrix-Normal Inverse-Wishart (MNIW) conjugate posterior distribution  (see \strong{Details}).
}
\details{
The Matrix-Normal Inverse-Wishart (MNIW) distribution \eqn{(\boldsymbol{B}, \boldsymbol{\Sigma}) \sim \textrm{MNIW}(\boldsymbol{\Lambda}, \boldsymbol{\Omega}, \boldsymbol{\Psi}, \nu)}{(B, \Sigma) ~ MNIW(\Lambda, \Omega, \Psi, \nu)} on random matrices \eqn{\boldsymbol{X}_{p \times q}}{X_(p x q)} and symmetric positive-definite \eqn{\boldsymbol{\Sigma}_{q \times q}}{\Sigma_(q x q)} is defined as
\deqn{
\begin{array}{rcl}
\boldsymbol{\Sigma} & \sim & \textrm{Inverse-Wishart}(\boldsymbol{\Psi}, \nu) \\
\boldsymbol{B} \mid \boldsymbol{\Sigma} & \sim & \textrm{Matrix-Normal}(\boldsymbol{\Lambda}, \boldsymbol{\Omega}^{-1}, \boldsymbol{\Sigma}),
\end{array}
}{
\Sigma ~ Inverse-Wishart(\Psi, \nu)
B | \Sigma ~ Matrix-Normal(\Lambda, \Omega^{-1}, \Sigma),
}
where the Matrix-Normal distribution is defined in \code{\link[=lmn_suff]{lmn_suff()}}.

The posterior MNIW distribution is required to be a proper distribution, but the prior is not.  For example, \code{prior = NULL} corresponds to the noninformative prior
\deqn{
\pi(B, \boldsymbol{\Sigma}) \sim |\boldsymbol{Sigma}|^{-(q+1)/2}.
}{
\pi(B, \Sigma) ~ |\Sigma|^{-(q+1)/2}.
}
}
\examples{
# generate data
n <- 50
q <- 2
p <- 3
Y <- matrix(rnorm(n*q),n,q) # response matrix
X <- matrix(rnorm(n*p),n,p) # covariate matrix
V <- .5 * exp(-(1:n)/n) # Toeplitz variance specification

suff <- lmn_suff(Y = Y, X = X, V = V, Vtype = "acf") # sufficient statistics
}
