% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.R
\name{remove}
\alias{remove}
\title{Remove Columns from Output}
\usage{
remove(...)
}
\arguments{
\item{...}{[character vector] name of the columns to be removed to the default output.}
}
\value{
A character vector
}
\description{
Auxiliary function that can be used when specifying the argument \code{columns} (e.g. calling \code{confint.lmm}) to remove columns.
}
\examples{
set.seed(10)
dW <- sampleRem(25, n.times = 1, format = "long")
e.lmm <- lmm(Y~X1, data = dW)

confint(e.lmm, columns = remove("estimate"))

}
\keyword{utilities}
