% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effects.lmm}
\alias{effects.lmm}
\title{Effects Derived For Linear Mixed Model}
\usage{
\method{effects}{lmm}(
  object,
  variable,
  newdata = NULL,
  type = c("identity", "none"),
  conditional = NULL,
  rhs = NULL,
  repetition = NULL,
  multivariate = FALSE,
  prefix.time = NULL,
  prefix.var = TRUE,
  sep.var = ",",
  ...
)
}
\arguments{
\item{object}{a \code{lmm} object.}

\item{variable}{[character] the variable relative to which the effect should be computed.}

\item{newdata}{[data.frame] a dataset reflecting the covariate distribution relative to which the average outcome or contrast should be computed.}

\item{type}{[character] should the average counterfactual outcome for each variable level be evaluated (\code{"identity"})?
Or the difference in average counterfactual outcome between each pair of  variable level (\code{"difference"})?
Can have an second element to consider a transformation of the outcome:
the change from baseline (\code{"change"}),
area under the outcome curve (\code{"auc"}),
or area under the outcome curve minus baseline (\code{"auc-b"}).}

\item{conditional}{[character] variable conditional to which the average conterfactual outcome or treatment effect should be computed.}

\item{rhs}{[numeric] the right hand side of the hypothesis.}

\item{repetition}{[character vector] repetition at which the effect should be assessed. By default it will be assessed at all repetitions.}

\item{multivariate}{[logical] should a multivariate Wald test be used to simultaneously test all null hypotheses.}

\item{prefix.time}{[character] When naming the estimates, text to be pasted before the value of the repetition variable.
Only relevant when \code{type = "aoc"} or \code{type = "ate"}.}

\item{prefix.var}{[logical] When naming the estimates, should the variable name be added or only the value?}

\item{sep.var}{[character] When naming the estimates, text to be pasted between the values to condition on.
Only relevant when \code{type = "aoc"} or \code{type = "ate"}.}

\item{...}{Arguments passed to \code{\link{anova.lmm}}.}
}
\description{
Estimate average counterfactual outcome or contrast of outcome from linear mixed models.
}
\examples{
#### simulate data in the long format ####
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")

#### Linear Mixed Model ####
eUN.lmm <- lmm(Y ~ visit + X1 + X2 + X5,
               repetition = ~visit|id, structure = "UN", data = dL)

## outcome
effects(eUN.lmm, variable = "X1")
effects(eUN.lmm, type = "difference", variable = "X1")
effects(eUN.lmm, type = "difference", variable = "X1", repetition = "3")

## change
effects(eUN.lmm, type = "change", variable = "X1")
effects(eUN.lmm, type = "change", variable = "X1", conditional = NULL)
effects(eUN.lmm, type = c("change","difference"), variable = "X1")

## auc
effects(eUN.lmm, type = "auc", variable = "X1")
effects(eUN.lmm, type = c("auc","difference"), variable = "X1")

#### fit Linear Mixed Model with interaction ####
dL$X1.factor <- as.factor(dL$X1)
dL$X2.factor <- as.factor(dL$X2)
eUN.lmmI <- lmm(Y ~ visit * X1.factor + X2.factor + X5,
               repetition = ~visit|id, structure = "UN", data = dL)

## average counterfactual conditional to a categorical covariate
effects(eUN.lmmI, variable = "X1.factor",
        conditional = c("X2.factor"), repetition = "3")
effects(eUN.lmmI, type = "change", variable = "X1.factor",
        conditional = c("X2.factor"), repetition = "3")
effects(eUN.lmmI, type = "auc", variable = "X1.factor",
        conditional = c("X2.factor"), repetition = "3")

## average difference in counterfactual conditional to a categorical covariate
effects(eUN.lmmI, type = "difference", variable = "X1.factor",
        conditional = c("X2.factor"), repetition = "3")
effects(eUN.lmmI, type = c("change","difference"), variable = "X1.factor",
        conditional = c("X2.factor"), repetition = "3")
effects(eUN.lmmI, type = c("auc","difference"), variable = "X1.factor",
        conditional = c("X2.factor"), repetition = "3")

## average difference in counterfactual conditional to a covariate
effects(eUN.lmmI, type = "difference", variable = "X1.factor",
        conditional = list(X5=0:2), repetition = "3")
effects(eUN.lmmI, type = c("difference","change"), variable = "X1.factor",
        conditional = list(X5=0:2))
}
\keyword{htest}
