% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effDim.R
\name{effDim}
\alias{effDim}
\title{Function to get the Effective Dimensions.}
\usage{
effDim(object)
}
\arguments{
\item{object}{an object of class LMMsolve}
}
\value{
A data.frame with the effective dimensions and penalties.

#' @examples
## Fit model on oats data
data(oats.data)

## Fit a model with a 1-dimensional spline at the plot level.
obj <- LMMsolve(fixed  = yield ~ rep + gen,
                spline = ~spl1D(x = plot, nseg = 20),
                data = oats.data)
effDim(obj)
}
\description{
Function to get the Effective Dimensions.
}
