% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LKTfunctions.R
\name{LKT}
\alias{LKT}
\title{LKT}
\usage{
LKT(
  data,
  usefolds = NA,
  components,
  features,
  fixedpars = NA,
  seedpars = NA,
  interacts = NA,
  curvefeats = NA,
  dualfit = FALSE,
  interc = FALSE,
  verbose = TRUE,
  epsilon = 1e-04,
  cost = 512,
  lowb = 1e-05,
  highb = 0.99999,
  type = 0,
  maketimes = FALSE,
  bias = 0,
  maxitv = 100,
  factrv = 1e+12,
  nosolve = FALSE,
  autoKC = rep(0, length(components)),
  autoKCcont = rep("NA", length(components)),
  connectors = rep("+", max(1, length(components) - 1))
)
}
\arguments{
\item{data}{A dataset with Anon.Student.Id and CF..ansbin.}

\item{usefolds}{Numeric Vector | Specifies the folds for model fitting in LKT; the features are still calculated across all folds to compute test fold fit externally}

\item{components}{A vector of factors that can be used to compute each features for each subject.}

\item{features}{a vector methods to use to compute a feature for the component.}

\item{fixedpars}{a vector of parameters for all features+components.}

\item{seedpars}{a vector of parameters for all features+components to seed non-linear parameter search.}

\item{interacts}{A list of components that interacts with component by feature in the main specification.}

\item{curvefeats}{vector of columns to use with "diff" functions}

\item{dualfit}{TRUE or FALSE, fit a simple latency using logit. Requires Duration..sec. column in data.}

\item{interc}{TRUE or FALSE, include a global intercept.}

\item{verbose}{provides more output in some cases.}

\item{epsilon}{passed to LiblineaR}

\item{cost}{passed to LiblineaR}

\item{lowb}{lower bound for non-linear optimizations}

\item{highb}{upper bound for non-linear optimizations}

\item{type}{passed to LiblineaR}

\item{maketimes}{Boolean indicating whether to create time based features (or may be precomputed)}

\item{bias}{passed to LiblineaR}

\item{maxitv}{passed to nonlinear optimization a maxit control}

\item{factrv}{controls the optim() function}

\item{nosolve}{causes the function to return a sparse data matrix of the features, rather than a solution}

\item{autoKC}{a vector to indicate whether to use autoKC for the component (0) or the k for the numebr of clusters}

\item{autoKCcont}{a vector of text strings set to "rand" for component to make autoKC assignment to cluster is randomized (for comaprison)}

\item{connectors}{a vector if linear equation R operators including +, * and :}
}
\value{
list of values "model", "coefs", "r2", "prediction", "nullmodel", "latencymodel", "optimizedpars","subjectrmse", "newdata", and "automat"
}
\description{
Compute a logistic regression model of learning for input data.
}
