% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GICDelta_down.R
\name{getDeltaH_down}
\alias{getDeltaH_down}
\title{Estimation of the Optimal \code{H_delta} Value to Guarantee Performance in the Downward CUSUM Control Chart}
\usage{
getDeltaH_down(
  n_I,
  alpha,
  beta,
  beta_ratio,
  H_minus,
  a,
  b,
  ARL_esp,
  m,
  N_init,
  N_final,
  known_alpha
)
}
\arguments{
\item{n_I}{Sample size in Phase I.}

\item{alpha}{Shape parameter of the Gamma distribution.}

\item{beta}{Scale parameter of the Gamma distribution.}

\item{beta_ratio}{Ratio between beta and its estimate.}

\item{H_minus}{Initial lower limit of the CUSUM chart.}

\item{a}{Tolerance level for the expected ARL (0 <= a < 1).}

\item{b}{Tolerance level for the expected ARL (0 < b < 1).}

\item{ARL_esp}{Desired expected ARL value.}

\item{m}{Number of states in the Markov matrix.}

\item{N_init}{Number of initial iterations.}

\item{N_final}{Number of final iterations.}

\item{known_alpha}{Indicates whether \code{alpha} is known (\code{TRUE}) or should be estimated (\code{FALSE}).}
}
\value{
A numerical value corresponding to the optimal \code{H_delta} for the downward CUSUM control chart, ensuring the expected performance.
}
\description{
This function calculates the optimal value of \code{H_delta} that guarantees a specific performance in the Gamma CUSUM control chart
for downward detection. It employs a Monte Carlo simulation approach and an iterative adjustment process to determine the appropriate value.

Following the methodology presented by Madrid‐Alvarez, García‐Díaz, and Tercero‐Gómez (2024),
this function allows adjusting \code{H_delta} for different sample size configurations, ensuring that the control chart
maintains the desired performance in terms of expected ARL.
\subsection{Features:}{
\itemize{
\item Implements Monte Carlo simulations to estimate \code{H_delta}.
\item Based on parameter estimates obtained in Phase I.
\item Iteratively adjusts \code{H_delta} until the specified ARL is achieved.
\item Displays the total execution time using \code{tictoc}.
}
}

\subsection{\strong{Recommendations}}{
\itemize{
\item This function is useful for estimating \code{H_delta} values in scenarios where the sample size differs from
the values reported in the reference paper:

\strong{Madrid‐Alvarez, H. M., García‐Díaz, J. C., & Tercero‐Gómez, V. G. (2024).}
\emph{A CUSUM control chart for gamma distribution with guaranteed performance.}
Quality and Reliability Engineering International, 40(3), 1279-1301.
\item \strong{The adjustment process is iterative and computationally demanding}, as its execution time depends on the number of iterations (\code{N_init + N_final}) and the sample size (\code{n_I}).
\item It is recommended to establish an appropriate convergence criterion to optimize execution time without compromising the accuracy of \code{H_delta} estimation.
\item For selecting values of \code{H_minus}, \code{a}, and \code{b}, it is advisable to consult the reference paper, which provides specific calibration strategies and recommendations.
}
}
}
\examples{
\donttest{
getDeltaH_down(n_I = 100, alpha = 1, beta = 1, beta_ratio = 1/2,
               H_minus = -4.1497, a = 0.1, b = 0.05, ARL_esp = 370,
               m = 100, N_init = 10, N_final = 1000, known_alpha = TRUE)
               }

}
