% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arriaga.R
\name{sen_arriaga_sym}
\alias{sen_arriaga_sym}
\title{Estimate sensitivity of life expectancy using a symmetrical Arriaga approach.}
\usage{
sen_arriaga_sym(
  mx1,
  mx2,
  age = 0:(length(mx1) - 1),
  nx = rep(1, length(mx1)),
  sex1 = "t",
  sex2 = sex1,
  closeout = TRUE
)
}
\arguments{
\item{mx1}{numeric vector of the mortality rates (central death rates) for population 1}

\item{mx2}{numeric vector of the mortality rates (central death rates) for population 2}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex1}{character either the sex for population 1: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{sex2}{character either the sex for population 2: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"}) assumed same as \code{sex1} unless otherwise specified.}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
numeric vector of life expectancy sensitivity to perturbations in mx evaluated at the average of \code{mx1} and \code{mx2}.
}
\description{
This approach conducts a classic Arriaga decomposition in both directions, averaging the (sign-adjusted) result, i.e. \code{a_avg = (arriaga(mx1,mx2, ...) - arriaga(mx2, mx1, ...)) / 2}, then approximates the sensitivity by dividing out the rate differences, i.e. \code{s = a_avg / (mx2 - mx1)}. A resulting decomposition will be exact because the two arriaga directions are exact, but this method might be vulnerable to 0s in the denominator.
}
\examples{
a <- .001
b <- .07
x <- 0:100
mx1 <- a * exp(x * b)
mx2 <- a/2 * exp(x * b)
s <- sen_arriaga_sym(mx1, mx2, age = x)

e01 <- mx_to_e0(mx1,age=x)
e02 <- mx_to_e0(mx2,age=x)
(Delta <- e02 - e01)
deltas <- mx2- mx1
sum(deltas * s)
mx_avg <- (mx1+mx2) / 2
\donttest{
mx_avg <- (mx1 + mx2) / 2
plot(x, s, type = 'l')
lines(x, sen_arriaga_instantaneous(mx_avg, age=x),col = "blue")
}
}
\seealso{
\code{\link{arriaga}}
}
