% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS_on_LDA.R
\name{print_model_run_message}
\alias{print_model_run_message}
\title{Print the message to the console about which combination of the 
  Time Series and LDA models is being run}
\usage{
print_model_run_message(models, i, LDA_models, control)
}
\arguments{
\item{models}{\code{data.frame} object returned from 
\code{\link{expand_TS}} that contains the combinations of LDA models, 
and formulas and nchangepoints used in the TS models.}

\item{i}{\code{integer} index of the row to use from \code{models}.}

\item{LDA_models}{List of LDA models (class \code{LDA_set}, produced by
\code{\link{LDA_set}}) or a singular LDA model (class \code{LDA},
produced by \code{\link[topicmodels]{LDA}}).}

\item{control}{A \code{list} of parameters to control the fitting of the
Time Series model including the parallel tempering Markov Chain 
Monte Carlo (ptMCMC) controls. Values not input assume defaults set by 
\code{\link{TS_control}}. Of particular importance here is 
the \code{logical}-class element named \code{quiet}.}
}
\value{
\code{NULL}.
}
\description{
If desired, print a message at the beginning of every model
  combination stating the TS model and the LDA model being evaluated.
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDAs <- LDA_set(document_term_table, topics = 2:3, nseeds = 2)
  LDA_models <- select_LDA(LDAs)
  weights <- document_weights(document_term_table)
  formulas <- c(~ 1, ~ newmoon)
  nchangepoints <- 0:1
  mods <- expand_TS(LDA_models, formulas, nchangepoints)
  print_model_run_message(mods, 1, LDA_models, TS_control())
}

}
