% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptMCMC.R
\name{prep_ids}
\alias{prep_ids}
\alias{update_ids}
\title{Initialize and update the chain ids throughout the ptMCMC algorithm}
\usage{
prep_ids(control = list())

update_ids(ids, swaps)
}
\arguments{
\item{control}{A \code{list} of parameters to control the fitting of the
Time Series model including the parallel tempering Markov Chain 
Monte Carlo (ptMCMC) controls. Values not input assume defaults set by 
\code{\link{TS_control}}.}

\item{ids}{The existing vector of chain ids.}

\item{swaps}{Chain configuration after among-temperature swaps.}
}
\value{
The vector of chain ids.
}
\description{
\code{prep_ids} creates and \code{update_ids} updates 
  the active vector of identities (ids) for each of the chains in the 
  ptMCMC algorithm. These ids are used to track trips of the particles
  among chains.
  \cr \cr
  These functions were designed to work within \code{\link{TS}} and 
  specifically \code{\link{est_changepoints}}, but have been generalized
  and would work within any general ptMCMC as long as \code{control},
  \code{ids}, and \code{swaps} are formatted properly.
}
\examples{
  prep_ids()
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDA_models <- LDA_set(document_term_table, topics = 2)[[1]]
  data <- document_covariate_table
  data$gamma <- LDA_models@gamma
  weights <- document_weights(document_term_table)
  data <- data[order(data[,"newmoon"]), ]
  saves <- prep_saves(1, TS_control())
  inputs <- prep_ptMCMC_inputs(data, gamma ~ 1, 1, "newmoon", weights,
                               TS_control())
  cpts <- prep_cpts(data, gamma ~ 1, 1, "newmoon", weights, TS_control())
  ids <- prep_ids(TS_control())
  for(i in 1:TS_control()$nit){
    steps <- step_chains(i, cpts, inputs)
    swaps <- swap_chains(steps, inputs, ids)
    saves <- update_saves(i, saves, steps, swaps)
    cpts <- update_cpts(cpts, swaps)
    ids <- update_ids(ids, swaps)
  }
}

}
