% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_plots.R
\name{plot.LDA_VEM}
\alias{plot.LDA_VEM}
\alias{LDA_plot_top_panel}
\alias{LDA_plot_bottom_panel}
\title{Plot the results of an LDATS LDA model}
\usage{
\method{plot}{LDA_VEM}(
  x,
  ...,
  xtime = NULL,
  xname = NULL,
  cols = NULL,
  option = "C",
  alpha = 0.8,
  LDATS = FALSE
)

LDA_plot_top_panel(
  x,
  cols = NULL,
  option = "C",
  alpha = 0.8,
  together = FALSE,
  LDATS = FALSE
)

LDA_plot_bottom_panel(
  x,
  xtime = NULL,
  xname = NULL,
  cols = NULL,
  option = "C",
  alpha = 0.8,
  together = FALSE,
  LDATS = FALSE
)
}
\arguments{
\item{x}{Object of class \code{LDA_VEM}.}

\item{...}{Not used, retained for alignment with base function.}

\item{xtime}{Optional x values used to plot the topic proportions according
to a specific time value (rather than simply the order of observations).}

\item{xname}{Optional name for the x values used in plotting the topic
proportions (otherwise defaults to "Document").}

\item{cols}{Colors to be used to plot the topics.
Any valid color values (\emph{e.g.}, see \code{\link[grDevices]{colors}},
\code{\link[grDevices]{rgb}}) can be input as with a standard plot. 
The default (\code{cols = NULL}) triggers use of 
\code{\link[viridis]{viridis}} color options (see \code{option}).}

\item{option}{A \code{character} string indicating the color option
from \code{\link[viridis]{viridis}} to use if `cols == NULL`. Four 
options are available: "magma" (or "A"), "inferno" (or "B"), "plasma" 
(or "C", the default option), "viridis" (or "D") and "cividis" (or "E").}

\item{alpha}{Numeric value [0,1] that indicates the transparency of the 
colors used. Supported only on some devices, see 
\code{\link[grDevices]{rgb}}.}

\item{LDATS}{\code{logical} indicating if the LDA plot is part of a larger 
LDATS plot output.}

\item{together}{\code{logical} indicating if the subplots are part of a 
larger LDA plot output.}
}
\value{
\code{NULL}.
}
\description{
Create an LDATS LDA summary plot, with a top panel showing
  the topic proportions for each word and a bottom panel showing the topic
  proportions of each document/over time. The plot function is defined for
  class \code{LDA_VEM} specifically (see \code{\link[topicmodels]{LDA}}).
  \cr \cr
  \code{LDA_plot_top_panel} creates an LDATS LDA summary plot 
  top panel showing the topic proportions word-by-word. \cr \cr
  \code{LDA_plot_bottom_panel} creates an LDATS LDA summary plot
  bottom panel showing the topic proportions over time/documents.
}
\examples{
\donttest{
  data(rodents)
  lda_data <- rodents$document_term_table
  r_LDA <- LDA_set(lda_data, topics = 4, nseeds = 10) 
  best_lda <- select_LDA(r_LDA)[[1]]
  plot(best_lda, option = "cividis")
  LDA_plot_top_panel(best_lda, option = "cividis")
  LDA_plot_bottom_panel(best_lda, option = "cividis")
}

}
