% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCurves.r
\name{plotCurves}
\alias{plotCurves}
\title{Plot the Relative Yield, YPR, SPR, SSB, and Recruitment curves}
\usage{
plotCurves(
  LB_obj,
  X = c("FM", "SSB", "SPR"),
  Y = c("SPR", "SSB", "Yield"),
  size.axtex = 12,
  size.title = 14,
  size.leg = 12,
  size.pt = 4,
  inc.pts = TRUE
)
}
\arguments{
\item{LB_obj}{An object of class \code{'LB_obj'} that contains the life history and fishing information}

\item{X}{a character value indicating what to plot on the x-axis: F/M (\code{"FM"}) or SSB (\code{"SSB"})}

\item{Y}{a character value indicating what to plot on the y-axis: \code{SPR}, \code{SSB}, \code{Yield}, \code{YPR} or \code{Rec}(multiple okay)}

\item{size.axtex}{size of the axis text}

\item{size.title}{size of axis title}

\item{size.leg}{size of legend text}

\item{size.pt}{size of the points on the plots}

\item{inc.pts}{Include points on the plots?}
}
\value{
a ggplot object
}
\description{
A function that plots the Relative Yield, YPR, SPR, SSB, and Recruitment curves
}
\author{
A. Hordyk
}
