% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{vis_network}
\alias{vis_network}
\title{Create an enhanced network visualization of ABC connections}
\usage{
vis_network(
  abc_results,
  top_n = 25,
  min_score = 0.1,
  show_significance = TRUE,
  node_size_factor = 5,
  color_by = "type",
  title = "ABC Model Network",
  show_entity_types = TRUE,
  label_size = 1,
  layout_seed = NULL
)
}
\arguments{
\item{abc_results}{A data frame containing ABC results.}

\item{top_n}{Number of top results to visualize.}

\item{min_score}{Minimum score threshold for including connections.}

\item{show_significance}{Logical. If TRUE, highlights significant connections.}

\item{node_size_factor}{Factor for scaling node sizes.}

\item{color_by}{Column to use for node colors. Default is 'type'.}

\item{title}{Plot title.}

\item{show_entity_types}{Logical. If TRUE, includes entity types in node labels.}

\item{label_size}{Relative size for labels. Default is 1.}

\item{layout_seed}{Optional seed for layout reproducibility. If NULL, no seed is set.}
}
\value{
NULL invisibly. The function creates a plot as a side effect.
}
\description{
This function creates an improved network visualization of ABC connections
that displays entity types when available, without enforcing type constraints.
}
