% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehensive_summary.R
\name{run_lbd}
\alias{run_lbd}
\title{Perform comprehensive literature-based discovery without type constraints}
\usage{
run_lbd(
  search_query,
  a_term,
  max_results = 100,
  discovery_approaches = c("abc", "anc", "lsi", "bitola"),
  include_visualizations = TRUE,
  output_file,
  api_key = NULL,
  dictionary_sources = c("local", "mesh", "umls"),
  entity_categories = c("disease", "drug", "gene")
)
}
\arguments{
\item{search_query}{Character string, the search query for retrieving initial articles.}

\item{a_term}{Character string, the source term (A) for discovery.}

\item{max_results}{Maximum number of results to return for each approach.}

\item{discovery_approaches}{Character vector, the discovery approaches to use.}

\item{include_visualizations}{Logical. If TRUE, generates visualizations.}

\item{output_file}{File path for the output report. Must be specified by user.}

\item{api_key}{Character string. API key for PubMed and other services.}

\item{dictionary_sources}{Character vector. Sources for entity dictionaries: "local", "mesh", "umls".}

\item{entity_categories}{Character vector. Entity categories to include.}
}
\value{
A list containing discovery results from all approaches.
}
\description{
This function performs a comprehensive literature-based discovery analysis
using multiple approaches without enforcing entity type constraints.
}
\examples{
\donttest{
# Example with temporary output file
temp_report <- file.path(tempdir(), "discovery_report.html")

results <- run_lbd(
  search_query = "migraine treatment",
  a_term = "migraine",
  max_results = 10,
  discovery_approaches = "abc",
  include_visualizations = FALSE,
  output_file = temp_report
)

# Clean up
unlink(temp_report)
unlink(list.files(tempdir(), pattern = "*.png", full.names = TRUE))
unlink(list.files(tempdir(), pattern = "*.html", full.names = TRUE))
}
}
