% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_preprocessing.R
\name{extract_entities}
\alias{extract_entities}
\title{Extract and classify entities from text with multi-domain types}
\usage{
extract_entities(
  text_data,
  text_column = "abstract",
  dictionary = NULL,
  case_sensitive = FALSE,
  overlap_strategy = c("priority", "all", "longest"),
  sanitize_dict = TRUE
)
}
\arguments{
\item{text_data}{A data frame containing article text data.}

\item{text_column}{Name of the column containing text to process.}

\item{dictionary}{Combined dictionary or list of dictionaries for entity extraction.}

\item{case_sensitive}{Logical. If TRUE, matching is case-sensitive.}

\item{overlap_strategy}{How to handle terms that match multiple dictionaries: "priority", "all", or "longest".}

\item{sanitize_dict}{Logical. If TRUE, sanitizes the dictionary before extraction.}
}
\value{
A data frame with extracted entities, their types, and positions.
}
\description{
This function extracts entities from text and optionally assigns them to specific
semantic categories based on dictionaries.
}
