% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_model.R
\name{abc_model_sig}
\alias{abc_model_sig}
\title{Apply the ABC model with statistical significance testing}
\usage{
abc_model_sig(
  co_matrix,
  a_term,
  c_term = NULL,
  a_type = NULL,
  c_type = NULL,
  min_score = 0.1,
  n_results = 100,
  n_permutations = 1000,
  scoring_method = c("multiplication", "average", "combined", "jaccard")
)
}
\arguments{
\item{co_matrix}{A co-occurrence matrix produced by create_cooccurrence_matrix().}

\item{a_term}{Character string, the source term (A).}

\item{c_term}{Character string, the target term (C). If NULL, all potential C terms will be evaluated.}

\item{a_type}{Character string, the entity type for A terms. If NULL, all types are considered.}

\item{c_type}{Character string, the entity type for C terms. If NULL, all types are considered.}

\item{min_score}{Minimum score threshold for results.}

\item{n_results}{Maximum number of results to return.}

\item{n_permutations}{Number of permutations for significance testing.}

\item{scoring_method}{Method to use for scoring ABC connections.}
}
\value{
A data frame with ranked discovery results and p-values.
}
\description{
This function extends the ABC model with statistical significance testing
to evaluate the strength of discovered connections.
}
